<?php
/*
Plugin Name: Pageflip5
Plugin URI: http://pageflip-books.com
Description:This plugin is a bridge between WordPress and Pageflip5, it allows to embed a Pageflip5 book template in a post. It can simply display all images attached to the post in a pageflip5 book, or you can make custom books taking advantages of all Pageflip5 features. Pageflip5 is not part of this Plugin, and to make it work properly, you need a Pageflip5 commercial license available at <a href='http://pageflip-books.com'>http://pageflip-books.com</a> 
Version: 1.4
Author: Abel Vincze
Author URI: http://iparigrafika.hu
License: GPL2
*/
/*
Copyright 2004-2015  Abel Vincze  (email: abel@iparigrafika.hu)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License, version 2, as 
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

class Pageflip5_WP_Plugin {
	static $counter = 0;

	public function __construct() {
	
		$this->counter = 0;
		// Initialize Settings
		if ( is_admin() ) {
			// Create the settings page in admin
			require_once(sprintf("%s/settings.php", dirname(__FILE__)));
			$pageflip5_wp_plugin_settings = new Pageflip5_WP_Plugin_Settings();
		}
		
	}
	
	public static function activate() {
		// Do nothing
	}
	public static function deactivate() {
		// Do nothing
	}
	
	public static function shortcode_pageflip5( $atts, $content ) {
		$width = 300;
		$height = 400;
		/*
		If there isn't any content defined inside opening/closing shortcode tags
		we check the image files attached to the post
		*/
		$size = $atts['size']? $atts['size']: 'large';
		$thumbs = $atts['thumbnails']? $atts['thumbnails']==true : 'true';
		if( !$content ) {
			/*
			$auto_content => content is a pageflip5 page content format, generated automatically from
			images attached to the WP blogpost and uploaded using WP media upload.
			
			If no width/height is set manually, the size of the pages will be equal to the biggest image's size.
			*/
			$auto_content = self::processAttachements( $size, $thumbs );
			$content = $auto_content['content'];
			$width = $auto_content['width'];
			$height = $auto_content['height'];
		}
		/*
		If no images were attached, display a default empty content.
		*/
		if( !$content && !$atts['pagedatafile'] ) {
			$content = '<div class="page"></div><div class="page"></div><div class="page"></div><div class="page"></div>';
		}
		/*
		Processing shortcode attributes
		*/
		$config_options = self::processAttributes( $atts );
		
		/*
		shortcode only attributes (they are not pageflip5 config options)
		
		$BookID - Book ID (appears in the URL Hash), and also added as CSS classs to pageflip5 elements (like book/pages)
		$name - is a unique name to the book, used in the opening book link when multiple pageflips are on the same page.
		*/
		$book_id = $atts['id']? $atts['id']: 'pageflip5_book'.self::$counter;
		$name = $atts['name']? $atts['name']: 'Pageflip 5 book '.self::$counter;
		$pf_id = 'pageflip'.self::$counter;
		
		return '<div id="pageflip-wrapper'.self::$counter++.'" class="pageflip-wrapper">
				<div id="'.$pf_id.'" class="pageflip">
					<a href="#'.$book_id.'" onClick="startPageflip(\''.$book_id.'\');">Open this book: '.$name.'</a>'.
					$content.'
				</div>
			</div>
			<script>registerPageflip( "'.$pf_id.'", { PageWidth: '.$width.', PageHeight: '.$height.', '.$config_options.' }, "'.$book_id.'" );</script>';
	}
	
	public static function pageflip5_enqueue_styles_scripts() {
		/*
		Enqueue needed .js and .css files.
		*/
		wp_register_script( 'pageflip5engine', plugins_url('/js/pageflip5-min.js', __FILE__ ) , array( 'jquery' ) );
		wp_enqueue_script( 'pageflip5engine' );

		wp_register_script( 'pageflip5loader', plugins_url('/js/pageflip5-loader.js', __FILE__ ) );
		wp_enqueue_script( 'pageflip5loader' );

		wp_register_style( 'pageflip5style', plugins_url('/css/pageflip.css', __FILE__ ) );
		wp_enqueue_style( 'pageflip5style' );
		wp_register_style( 'pageflip5customstyle', plugins_url('/css/pageflip-custom.css', __FILE__ ) );
		wp_enqueue_style( 'pageflip5customstyle' );
	}
	public static function pageflip5_header() {
		// script in the header.
		// collects informations about pageflip5 book on the page,
		// manages pageflip5 book start/close/switch
		$option = get_option('pageflip5_wp_plugin_option');
		$controlbarfile = plugins_url('/controlbar_svg.html', __FILE__ );
		echo '<script>var defaultConfigOptions = { '.$option[ 'defaults_id' ].' , ControlbarFile: "'.$controlbarfile.'", Copyright: "'.$option[ 'copyright_id' ].'", Key: "'.$option[ 'key_id' ].'" };</script>';
	}
	public static function processAttachements( $size, $thumbs ) {
		global $post;
		$content = '';
		$width = 0;
		$height = 0;
		$args = array(  
			'post_parent'    => $post->ID,           // For the current post  
			'post_type'      => 'attachment',        // Get all post attachments  
			'post_mime_type' => 'image',        	 // Only grab images  
			'order'          => 'ASC',               // List in ascending order  
			'orderby'        => 'menu_order',        // List them in their menu order  
			'numberposts'    => -1,                  // Show all attachments  
			'post_status'    => null,                // For any post status  
		);
		$attachments = get_posts($args);
		if( $size != "thumbnail" &&
			$size != "medium" &&
			$size != "large" &&
			$size != "full" ) { $size = "large"; }	
		if ($attachments) {   
			// Initialize a counter so we can keep track of which image we are on.  
			$count = 0;  
			// Now we loop through all of the images that we found   
			foreach ($attachments as $attachment) {
				$image_attributes = wp_get_attachment_image_src( $attachment->ID , $size );
				if( $thumbs ) $thumbnail_attributes = wp_get_attachment_image_src( $attachment->ID , 'thumbnail' );
				$content = $content.'<div class="page" data-background-file="'.$image_attributes[0].'"'.
							($thumbs? 'data-thumbnail-image="'.$thumbnail_attributes[0].'"': '').'></div>';
				if( $image_attributes[1]>$width) $width = $image_attributes[1];
				if( $image_attributes[2]>$height) $height = $image_attributes[2];
			}
		}
		return array(
			'content'   =>  $content,
			'width'     =>  $width - $width%2,
			'height'    =>  $height- $height%2
		);
	}
	/*
	Attribute value, Config Option (name), and default values.
	return a part of the config option in javascript object format.
	*/
	public static function optString( $pAttr, $pName, $pDefault=null ) {
		if( !$pAttr ) return !$pDefault? '': $pName.': "'.$pDefault.'", ';
		return $pName.': "'.$pAttr.'", ';
	}
	public static function optBoolean( $pAttr, $pName, $pDefault=null ) {
		if( !$pAttr ) return !$pDefault? '': $pName.': '.($pDefault===true?'true':'false').', ';
		return $pName.': '.$pAttr.', ';
	}
	public static function optNumber( $pAttr, $pName, $pDefault=null ) {
		if( !$pAttr ) return !$pDefault? '': $pName.': '.$pDefault.', ';
		return $pName.': '.$pAttr.', ';
	}
	/*
	process shortcode attributes, to build pageflip5 config option
	returns a javascript Config Option object 
	*/
	public static function processAttributes( $atts ) {
		/*
		Convert lowercase shortcode attributes, to Pageflip5 ConfigOptions.
		Only options set as shartcode attribute are needed.
		*/
		$co =	self::optNumber(  $atts['pagewidth'], 'PageWidth' ).
				self::optNumber(  $atts['pageheight'], 'PageHeight' ).
				self::optNumber(  $atts['coverwidth'], 'CoverWidth' ).
				self::optNumber(  $atts['coverheight'], 'CoverHeight' ).
				self::optBoolean( $atts['hardcover'], 'HardCover' ).
				self::optBoolean( $atts['hardpages'], 'HardPages' ).
				self::optBoolean( $atts['centersinglepage'], 'CenterSinglePage' ).
				self::optNumber(  $atts['stagewidth'], 'StageWidth' ).
				self::optNumber(  $atts['stageheight'], 'StageHeight' ).
				self::optNumber(  $atts['margin'], 'Margin' ).
				self::optNumber(  $atts['margintop'], 'MarginTop' ).
				self::optNumber(  $atts['marginbottom'], 'MarginBottom' ).
				self::optNumber(  $atts['marginleft'], 'MarginLeft' ).
				self::optNumber(  $atts['marginright'], 'MarginRight' ).
				self::optBoolean( $atts['autoscale'], 'AutoScale' ).
				self::optBoolean( $atts['fullscale'], 'FullScale' ).
				self::optBoolean( $atts['fillscale'], 'FillScale' ).
				self::optBoolean( $atts['upscale'], 'UpScale' ).
				self::optBoolean( $atts['scaletosinglepage'], 'ScaleToSinglePage' ).
				self::optBoolean( $atts['autostageheight'], 'AutoStageHeight' ).
				self::optBoolean( $atts['flexiblecontent'], 'FlexibleContent' ).
				self::optNumber(  $atts['Flexiblecontentminwidth'], 'FlexibleContentMinWidth' ).
				self::optNumber(  $atts['startpage'], 'StartPage' ).
				self::optNumber(  $atts['minpagelimit'], 'MinPageLimit' ).
				self::optNumber(  $atts['maxpagelimit'], 'MaxPageLimit' ).
				self::optBoolean( $atts['startautoflip'], 'StartAutoFlip' ).
				self::optBoolean( $atts['autoflipenabled'], 'AutoFlipEnabled' ).
				self::optBoolean( $atts['zoomenabled'], 'ZoomEnabled' ).
				self::optBoolean( $atts['fullscreenenabled'], 'FullScreenEnabled' ).
				self::optNumber(  $atts['autoflipinterval'], 'AutoFlipInterval' ).
				self::optNumber(  $atts['autofliploop'], 'AutoFlipLoop' ).
				self::optBoolean( $atts['verticalmode'], 'VerticalMode' ).
				self::optBoolean( $atts['righttoleft'], 'RightToLeft' ).
				self::optBoolean( $atts['alwaysopened'], 'AlwaysOpened' ).
				self::optString(  $atts['pagedatafile'], 'PageDataFile' ).
				self::optBoolean( $atts['preflip'], 'Preflip' ).
				self::optString(  $atts['controlbarfile'], 'ControlbarFile' ).
				self::optBoolean( $atts['controlbartofront'], 'ControlbarToFront' ).
				self::optBoolean( $atts['thumbnails'], 'Thumbnails' ).
				self::optBoolean( $atts['thumbnailstofront'], 'ThumbnailsToFront' ).
				self::optNumber(  $atts['thumbnailsautohide'], 'ThumbnailsAutoHide' ).
				self::optBoolean( $atts['thumbnailshidden'], 'ThumbnailsHidden' ).
				self::optNumber(  $atts['thumbnailwidth'], 'ThumbnailWidth' ).
				self::optNumber(  $atts['rhumbnailheight'], 'ThumbnailHeight' ).
				self::optBoolean( $atts['rhumbnailalwayscentered'], 'ThumbnailAlwaysCentered' ).
				self::optBoolean( $atts['rransparency'], 'Transparency' ).
				self::optNumber(  $atts['pagecache'], 'PageCache' ).
				self::optBoolean( $atts['noflipshadow'], 'NoFlipShadow' ).
				self::optBoolean( $atts['dropshadow'], 'DropShadow' ).
				self::optBoolean( $atts['emboss'], 'Emboss' ).
				self::optNumber(  $atts['dropshadowopacity'], 'DropShadowOpacity' ).
				self::optNumber(  $atts['fliptopshadowopacity'], 'FlipTopShadowOpacity' ).
				self::optNumber(  $atts['flipshadowopacity'], 'FlipShadowOpacity' ).
				self::optNumber(  $atts['embossopacity'], 'EmbossOpacity' ).
				self::optNumber(  $atts['hardflipshadowopacity'], 'HardFlipShadowOpacity' ).
				self::optNumber(  $atts['prefliparea'], 'PreflipArea' ).
				self::optNumber(  $atts['secondarydragarea'], 'SecondaryDragArea' ).
				self::optNumber(  $atts['insidedragarea'], 'InsideDragArea' ).
				self::optNumber(  $atts['flipduration'], 'FlipDuration' ).
				self::optNumber(  $atts['bookoffsetx'], 'BookOffsetX' ).
				self::optNumber(  $atts['bookoffsety'], 'BookOffsetY' ).
				self::optNumber(  $atts['teardistance'], 'TearDistance' ).
				self::optBoolean( $atts['performanceaware'], 'PerformanceAware' ).
				self::optString(  $atts['pagertext'], 'PagerText' ).
				self::optBoolean( $atts['pagerskip'], 'PagerSkip' ).
				self::optBoolean( $atts['hidecopyright'], 'HideCopyright' ).
				self::optBoolean( $atts['hashcontrol'], 'HashControl' ).
				self::optBoolean( $atts['hotkeys'], 'HotKeys' ).
				self::optBoolean( $atts['mousecontrol'], 'MouseControl' ).
				self::optString(  $atts['sharelink'], 'ShareLink' ).
				self::optString(  $atts['sharetext'], 'ShareText' ).
				self::optString(  $atts['sharevia'], 'ShareVia' ).
				self::optString(  $atts['shareimageurl'], 'ShareImageURL' ).
				
				// Pageflip5 1.2 new options
				self::optBoolean( $atts['googleanalytics'], 'GoogleAnalytics' ).
				self::optBoolean( $atts['showcopyright'], 'ShowCopyright' ).
				self::optBoolean( $atts['clickzoom'], 'ClickZoom' ).
				self::optBoolean( $atts['disableselection'], 'DisableSelection' ).
				
				// Pageflip5 1.3 new options
				self::optBoolean( $atts['pinchzoom'], 'PinchZoom' ).
				self::optBoolean( $atts['singlepagemode'], 'SinglePageMode' ).
				self::optBoolean( $atts['thumbnailslazyload'], 'ThumbnailsLazyLoad' ).

				// Pageflip5 1.4 new options
				self::optBoolean( $atts['automaxheight'], 'AutoMaxHeight' ).
				self::optNumber(  $atts['maxheightoffset'], 'MaxHeightOffset' ).
				
				self::optString(  $atts['copyright'], 'Copyright' ).
				self::optString(  $atts['key'], 'Key' );
				

		return $co;
	}
}

add_action( 'wp_enqueue_scripts', array('Pageflip5_WP_Plugin', 'pageflip5_enqueue_styles_scripts') );	
add_action( 'wp_head', array('Pageflip5_WP_Plugin', 'pageflip5_header') );

// Installation and uninstallation hooks (isn't used yet)
//register_activation_hook( __FILE__, array('Pageflip5_WP_Plugin', 'activate') );
//register_deactivation_hook( __FILE__, array('Pageflip5_WP_Plugin', 'deactivate') );

// instantiate the plugin class
$pageflip5_wp_plugin = new Pageflip5_WP_Plugin();

// Add a link to the settings page onto the plugin page
if( is_admin() ) {
	// Add the settings link to the plugins page
	function plugin_settings_link($links) { 
		$settings_link = '<a href="options-general.php?page=pageflip5_wp_plugin_settings_page">Settings</a>'; 
		array_unshift($links, $settings_link); 
		return $links; 
	}
	$plugin = plugin_basename(__FILE__); 
	add_filter("plugin_action_links_$plugin", 'plugin_settings_link');
}
add_shortcode( 'pageflip5', array('Pageflip5_WP_Plugin', 'shortcode_pageflip5') );
?>