<?php
class Pageflip5_WP_Plugin_Settings {

	private $options;
	
	public function __construct() {
		add_action( 'admin_menu', array( $this, 'add_plugin_page' ) );
		add_action( 'admin_init', array( $this, 'page_init' ) );
	}
	public function add_plugin_page() {
		// This page will be under "Settings"
		add_options_page(
			'Pageflip5 Plugin Settings', 
			'Pageflip5 Plugin', 
			'manage_options', 
			'pageflip5_wp_plugin_settings_page', 
			array( $this, 'create_admin_page' )
		);
	}
	public function create_admin_page() {
		// Set class property
		$this->options = get_option( 'pageflip5_wp_plugin_option' );
		?>
		<div class="wrap">
			<?php screen_icon(); ?>
			<h2>Pageflip5 Plugin Settings</h2>
			<p>Here is where you can unlock your copy of Pageflip5, and set default settings for it.</p>
			<form method="post" action="options.php">
			<?php
				// This prints out all hidden setting fields
				settings_fields( 'pageflip5_wp_plugin_option_group' );   
				do_settings_sections( 'pageflip5_wp_plugin_settings_page' );
				submit_button(); 
			?>
			</form>
		</div>
		<?php
	}

	public function page_init() {        
		register_setting(
			'pageflip5_wp_plugin_option_group', // Option group
			'pageflip5_wp_plugin_option', // Option name
			array( $this, 'sanitize' ) // Sanitize
		);
		
		add_settings_section(
			'pf5_ss_unlock', // ID
			'Unlock Pageflip5', // Title
			array( $this, 'print_unlock_section_info' ), // Callback
			'pageflip5_wp_plugin_settings_page' // Page
		);  
		
		add_settings_field(
			'copyright_id', // ID
			'Copyright text', // Title 
			array( $this, 'copyright_callback' ), // Callback
			'pageflip5_wp_plugin_settings_page', // Page
			'pf5_ss_unlock' // Section           
		);      
		
		add_settings_field(
			'key_id', 
			'Key', 
			array( $this, 'key_callback' ), 
			'pageflip5_wp_plugin_settings_page', 
			'pf5_ss_unlock'
		);      

		add_settings_section(
			'pf5_ss_options', // ID
			'Pageflip5 default settings', // Title
			array( $this, 'print_defaults_section_info' ), // Callback
			'pageflip5_wp_plugin_settings_page' // Page
		);  
		
		add_settings_field(
			'defaults_id', // ID
			'Default Settings', // Title 
			array( $this, 'defaults_callback' ), // Callback
			'pageflip5_wp_plugin_settings_page', // Page
			'pf5_ss_options' // Section           
		);      

	}
	public function sanitize( $input ) {
		if( !empty( $input['copyright_id'] ) ) $input['copyright_id'] = sanitize_text_field( $input['copyright_id'] );  
		if( !empty( $input['key_id'] ) ) $input['key_id'] = sanitize_text_field( $input['key_id'] );
		if( !empty( $input['defaults_id'] ) ) $input['defaults_id'] = sanitize_text_field( $input['defaults_id'] );
		else $input['defaults_id'] = sanitize_text_field( 'AutoScale: true, AutoStageHeight: true , DropShadow: true, PerformanceAware: true, HashControl: true, Margin: 0, MarginTop: 32, MarginBottom: 64, FullScreenEnabled: true, HotKeys: false' );
		return $input;
	}
	public function print_unlock_section_info() {
		print 'Enter your Copyright text and Key below. You can generate your own Key using the <a href="http://pageflip-books.com/keygen.php" target="_blank">online Key-Generator</a> for Pageflip5.';
	}
	public function print_defaults_section_info() {
		print 'This is the default Configuration Options for all Pageflip5 Book on this Blog. They can be optionally overwritten by attributes with the same name (but lowercase) in the [pageflip5] shortcode used in Posts to embed Pageflip5. Please edit it carefully, a simple  mistype can cause the plugin to not function correctly! If it stops functionning, just delete it, and the default values will be restored. <a href="http://pageflip-books.com/documentation-configuration.php" target="_blank">More about available Configuration Options</a>';
	}
	public function copyright_callback()  {
		printf( '<input type="text" id="copyright_id" name="pageflip5_wp_plugin_option[copyright_id]" value="%s" class="regular-text ltr" />', esc_attr( $this->options['copyright_id']) );
	}
	public function key_callback() {
		printf( '<input type="text" id="key_id" name="pageflip5_wp_plugin_option[key_id]" value="%s" class="regular-text ltr code" />', esc_attr( $this->options['key_id']) );
	}
	public function defaults_callback() {
		printf( '<textarea id="defaults_id" name="pageflip5_wp_plugin_option[defaults_id]" class="large-text code">%s</textarea>', esc_textarea( $this->options['defaults_id']) );
	}
}
